/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.mappers.special;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.config.correct.ConfigCorrection;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.RecordEditor;
import io.github.noeppi_noeppi.libx.impl.config.wrapper.TypesafeMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecordValueMapper<T extends Record>
implements ValueMapper<T, JsonObject> {
    private final Class<T> clazz;
    private final List<TypesafeMapper> mappers;
    private final Constructor<T> ctor;

    public RecordValueMapper(Class<T> clazz, Function<Type, ValueMapper<?, ?>> mapperFunc) {
        this.clazz = clazz;
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException("Can't create record config value mapper for non-record class.");
        }
        RecordComponent[] parts = this.clazz.getRecordComponents();
        Class[] types = new Class[parts.length];
        ImmutableList.Builder mappers = ImmutableList.builder();
        for (int i = 0; i < parts.length; ++i) {
            types[i] = parts[i].getType();
            mappers.add((Object)new TypesafeMapper(mapperFunc.apply(parts[i].getGenericType())));
        }
        this.mappers = mappers.build();
        if (this.mappers.isEmpty()) {
            throw new IllegalArgumentException("Can't create record config value mapper for empty record.");
        }
        try {
            this.ctor = this.clazz.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Can't create record config value mapper for class: " + clazz, e);
        }
    }

    @Override
    public Class<T> type() {
        return this.clazz;
    }

    @Override
    public Class<JsonObject> element() {
        return JsonObject.class;
    }

    @Override
    public T fromJson(JsonObject json) {
        RecordComponent[] parts = this.clazz.getRecordComponents();
        Object[] values = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = this.mappers.get(i).fromJson(json.get(parts[i].getName()));
        }
        try {
            return (T)((Record)this.ctor.newInstance(values));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to create record for config.", e);
        }
    }

    @Override
    public JsonObject toJson(T value) {
        JsonObject json = new JsonObject();
        RecordComponent[] parts = this.clazz.getRecordComponents();
        for (int i = 0; i < parts.length; ++i) {
            try {
                json.add(parts[i].getName(), this.mappers.get(i).toJson(parts[i].getAccessor().invoke(value, new Object[0])));
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to get record value for config.", e);
            }
        }
        return json;
    }

    @Override
    public T fromNetwork(FriendlyByteBuf buffer) {
        RecordComponent[] parts = this.clazz.getRecordComponents();
        Object[] values = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = this.mappers.get(i).fromNetwork(buffer);
        }
        try {
            return (T)((Record)this.ctor.newInstance(values));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to create record for config.", e);
        }
    }

    @Override
    public void toNetwork(T value, FriendlyByteBuf buffer) {
        RecordComponent[] parts = this.clazz.getRecordComponents();
        for (int i = 0; i < parts.length; ++i) {
            try {
                this.mappers.get(i).toNetwork(parts[i].getAccessor().invoke(value, new Object[0]), buffer);
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to get record value for config.", e);
            }
        }
    }

    @Override
    public Optional<T> correct(JsonElement json, ConfigCorrection<T> correction) {
        RecordComponent[] parts = this.clazz.getRecordComponents();
        if (json.isJsonObject()) {
            Object[] args = new Object[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                int idx = i;
                String name = parts[i].getName();
                Optional obj = correction.tryCorrect(json.getAsJsonObject().has(name) ? json.getAsJsonObject().get(name) : null, this.mappers.get(idx), record -> {
                    try {
                        return Optional.of(parts[idx].getAccessor().invoke(record, new Object[0]));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        return Optional.empty();
                    }
                });
                if (!obj.isPresent()) {
                    return Optional.empty();
                }
                args[i] = obj.get();
            }
            try {
                return Optional.of((Record)this.ctor.newInstance(args));
            }
            catch (ReflectiveOperationException e) {
                return Optional.empty();
            }
        }
        if (parts.length == 1) {
            Optional singleArgValue = correction.tryCorrect(json, this.mappers.get(0), record -> {
                try {
                    return Optional.of(parts[0].getAccessor().invoke(record, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return Optional.empty();
                }
            });
            return singleArgValue.flatMap(value -> {
                try {
                    return Optional.of((Record)this.ctor.newInstance(value));
                }
                catch (ReflectiveOperationException e) {
                    return Optional.empty();
                }
            });
        }
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<T> createEditor(ValidatorInfo<?> validator) {
        return new RecordEditor<T>(this.clazz, this.mappers, this.ctor);
    }
}

